<?php
/*--------------------------------------------------------------------
 OnGetProductModelEventListener.php 2020-2-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Product\Model\Listener;

use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetProductInfoEventInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetProductModelEventInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetProductModelEvent;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitModelEvent;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Model;

/**
 * Class OnGetProductModelEventListener
 * @package Gambio\Shop\Product\Model\Listener
 */
class OnGetProductModelEventListener
{
    /**
     * @param OnGetProductModelEventInterface $event
     */
    public function __invoke(OnGetProductModelEventInterface $event)
    {
        $productModel          = new Model($event->product()->getModel());
        $sellingUnitModelEvent = new OnGetSellingUnitModelEvent($event->product(),
                                                                $event->productId(),
                                                                $event->modifierIdentifiers(),
                                                                $event->languageId(),
                                                                $productModel);
        $event->dispatcher()->dispatch($sellingUnitModelEvent);
        
        $event->setModel($sellingUnitModelEvent->model());
    }
}